;;; -*- Mode:Common-Lisp; Package:EH; Fonts:(CPTFONT HL10B HL12BI HL12B CPTFONTB); Base:101; *Patch-File:T -*-

;1;;                     RESTRICTED RIGHTS LEGEND          *
;1;; Use, duplication, or disclosure by the Government is subject to*
;1;; restrictions as set forth in subdivision (b)(3)(ii) of the Rights in*
;1;; Technical Data and Computer Software clause at 52.227-7013.*
;1;;                   TEXAS INSTRUMENTS INCORPORATED.*
;1;;                            P.O. BOX 149149*
;1;;                         AUSTIN, TEXAS 78714-9149*
;1;;                             MS 2151*
;1;; Copyright (C) 1986,1987, 1988, 1989 Texas Instruments Incorporated. All rights reserved.*

;;;----------------------------------------------------------------------
;;; This software developed by:
;;;	James Rice
;;; at the Stanford University Knowledge Systems Lab in 1986, 1987.
;;;
;;; This work was supported in part by:
;;;	DARPA Grant F30602-85-C-0012
;;;----------------------------------------------------------------------
;;;  Much of this file is derived from code licensed from Texas Instruments
;;;  Inc.  Since we'd like them to adopt these changes, we're claiming
;;;  no rights to them, however, the following restrictions apply to the
;;;  TI code:
;;; Your rights to use and copy Explorer System Software must be obtained
;;; directly by license from Texas Instruments Incorporated.  Unauthorized
;;; use is prohibited.
;;;----------------------------------------------------------------------

;1;; This file contains the definition of a number of new commands for the window debugger.*

(DEFVAR 4*window-debugger-enhancements-to-add** :all
"2Can have the value :All, in which case all commands are loaded,
 :Menu in which case the user is prompted, or a list of commands to load.*")

(DEFPARAMETER 4*window-debugger-enhancements-commands**
  '(("3Debug Stack Group*" :value (nil nil ((comw-debug-stack-group-cmd t))))
    ("3Modify Inspect*" :value (nil nil ((comw-modify-inspect t)))))
"2This is a list of the commands which can be added to the Window-debugger.  The
 structure of this list is as follows :-
 It is made of items.  Each item is a list of the form (Menustring :Value spec)
 the spec is used to determine which commands for which tools is represented
 by the menu item.  The spec is a list of the form
 (nil nil window-debugger-commands)
 Each element of window-debugger-commands has the form
 (command-name put-in-frames-menu-p).*")

(DEFUN 4install-window-debugger-commands* ()
"2Installs all of the commands that the user wants.*"
  (tv::select-and-install-commands *window-debugger-enhancements-commands*
				   *window-debugger-enhancements-to-add*))

;1-------------------------------------------------------------------------------*

;1;; The Debug Stack Group Command.*

;1-------------------------------------------------------------------------------*

;1;; The following are property assignments, which specify properties for types*
;1;; which contain stack groups which can be debugged.  A property is added to*
;1;; the name of the type under the Key :Stack-Group-Accessor, whose value is*
;1;; either a function object or a symbol, whose functional value is an access*
;1;; function.*

(PUTPROP 'si:process 'PROCESS-STACK-GROUP :stack-group-accessor)
(PUTPROP 'STACK-GROUP 'IDENTITY :stack-group-accessor)

(DEFUN 4extract-a-stack-group* (something)
"2This function is passed something, which contains a stack group.  It extracts
 the stack group and returns it.  The way that it does it is to look on the
 property list of the type of the argument.  If there is a property called
 :Stack-Group-Accessor then this is used as an access function, by which the
 stack group can be extracted.  The value of this property can be either a
 symbol or a function.*"
  (LET ((the-accessor (GET (TYPE-OF something) :stack-group-accessor)))
       (IF (EQUAL nil the-accessor)
	   :error
	   (FUNCALL (IF (SYMBOLP the-accessor)
			(SYMBOL-FUNCTION the-accessor)
			the-accessor)
		    something))))

(DEFUN 4redefined-sg-funcall-in-frame* (sg frame function &rest args)
"2This function is a redefined version of sg-funcall-in-frame.  For some reason
 that I don't understand something goes wrong with evaluating expressions in the
 lisp listener pane and nasty things happen.  This change makes sure that things
 are evaluated in the context of the stack group as a whole but not in the
 context of the current frame - a bit of a restriction, I know but not that bad
 really and still worth it to have this feature.*"
  (IGNORE frame)
  (sg-apply sg function args))

;1 TAC 09-04-89 - commented this one out because a different version of same function immediately follows *
;1(DEFUN debug-a-stack-group (something)*
;1"This procedure is passed something that contains a stack group.  It extacts*
;1 the stack group and calls the window debugger to debug it.  In order to do this*
;1 it binds the special variables error-sg and current-frame, which are known to*
;1 the debugger.  Error-Sg is the stack group which is to be debugged and*
;1 current-frame is the stack frame pointer.  This is set to function at the*
;1 bottom of the stack."*
;1  (LET ((*error-sg* (extract-a-stack-group something)))*
;1       (IF (EQUAL *error-sg* :error)*
;	1   (PROGN (BEEP)*
;		1  (FORMAT tv:selected-window "~&~S cannot be debugged.~%"*
;			1  something))*
;	1   (LET ((*current-frame* (sg-initial-function-index error-sg))*
;		1 (* nil)*
;		1 (** nil)*
;		1 (*** nil))        *
;		1(DECLARE (SPECIAL *error-sg* *current-frame* * ** ***))*
;		1(letf ((#'sg-funcall-in-frame #'redefined-sg-funcall-in-frame))*
;		1      (com-window-debugger *error-sg**
;			1  (MAKE-INSTANCE 'FERROR :condition-names nil*
;					1  :format-string "Debug a Stack Group"*
;					1  :format-args nil*
;					1  :initial-error-message-printed-p t)))))))*

(DEFUN 4debug-a-stack-group* (something)
"2This procedure is passed something that contains a stack group.  It extacts
 the stack group and calls the window debugger to debug it.  In order to do this
 it binds the special variables error-sg and current-frame, which are known to
 the debugger.  Error-Sg is the stack group which is to be debugged and
 current-frame is the stack frame pointer.  This is set to function at the
 bottom of the stack.*"
  (LET ((sg (extract-a-stack-group something)))
       (IF (EQUAL *error-sg* :error)
	   (PROGN (BEEP)
		  (FORMAT tv:selected-window "3~&~S cannot be debugged.~%*"
			  something))
	   (USING-RESOURCE (STREAM tv::background-lisp-interactors)
	     (LET ((*terminal-io* stream)
		   (*debug-io* stream)
		   (*error-output* stream)
		   (*trace-output* stream)
		   (action (SEND stream :deexposed-typeout-action)))
	          (DECLARE (SPECIAL *terminal-io* *debug-io*
				    *error-output* *trace-output*))
		  (UNWIND-PROTECT
		      (PROGN (SEND stream :set-deexposed-typeout-action :expose)
			     (EH sg))
		    (SEND stream :set-deexposed-typeout-action action)
		    (SEND stream :deactivate)))))))

(DEFUN 4comw-debug-stack-group* (IGNORE ignore &aux thing)
"2This is the command procedure for the window debugger, which causes the user to
 be prompted to point at a stack group or stack group containing data structure.*"
  (AND (SETQ thing (window-read-thing
			"3~&Type or mouse a process or stack group to debug:~%*"))
       (PROCESS-RUN-FUNCTION "3Window Debugger from Window Debugger*"
			     #'debug-a-stack-group thing)))

;1; This window debugger command was copied and modified from the command, which controls the*
;1; inspect option.  It defines a command called Comw-Debug-Stack-Group-Cmd, which is activated*
;1; either from a menu or by the keystroke h-S.  It causes the user to be prompted for a stack *
;1; group containing data structure and starts off a new debugger frame, which debugs that stack group.*

(DEFCOMMAND 4comw-debug-stack-group-cmd* nil
  '(:description
     "3Run a new debugger in a selected stack group*" :names "3Dbg SG*" 
    :keys (#\h-s))
   (SEND *window-debugger* :set-who-line-doc-string-overide
	 "3Select a stack group, or something containing one, to debug.*")
   (UNWIND-PROTECT
      (PROGN
	(comw-debug-stack-group *error-sg* *error-object*)
	(tv:delaying-screen-management
	    (WHEN (EQUAL (SEND *window-debugger* :configuration)
			 'step-configuration)
	          (SEND *window-debugger* :set-configuration
			'debugger-configuration))))
      (PROGN (SEND *window-debugger* :set-who-line-doc-string-overide nil)
             (SEND *window-debugger* :handle-prompt))))

;1-------------------------------------------------------------------------------*

;1;; The Modify Inspect command.*

;1-------------------------------------------------------------------------------*

(DEFMETHOD 4(debugger-frame :inspect-history-window*) ()
"2Makes the inspect-history-window instance variable visible.*"
  inspect-history-window)

(DEFMETHOD 4(debugger-frame :inspect-window*) ()
"2Makes the inspect-window instance variable visible.*"
  inspect-window)

(DEFMETHOD 4(debugger-frame :update-**)  ()
"2A dummy method, because * is updated by explicit typein or by the middle
 button.*"
  nil)

(DEFCOMMAND 4comw-modify-inspect* ()
            '(:description "3Modify something in the inspect pane.*"
              :names "3ModInsp*" :keys (#\c-sh-m))
  (LET ((tv::history (SEND *window-debugger* :inspect-history-window))
	(tv::inspectors (LIST (SEND *window-debugger* :inspect-window)))
	(tv::frame *window-debugger*))
       (DECLARE (SPECIAL tv::top-item tv::history tv::inspectors tv::frame))
       (SETQ tv:top-item
	     (tv::inspect-modify-object *terminal-io* tv::history tv::inspectors))
       (tv::update-panes)))
;1-------------------------------------------------------------------------------*

;1; The following fix lets the value of Self be printed in the locals window*
;1; for methods which would not otherwise have this happen.*

;1; This facility is switched on by the variable*
;1; eh:*show-self-in-locals-window-anyway* .  Set it to non-nil to*
;1; enable it.  If it is set to :Always then Self is printed even for*
;1; non-methods.*

;1;; Code by JPR.*
(DEFVAR 4*show-self-in-locals-window-anyway** nil
"2Controls how Self is displayed in the window debugger.  Can have the values;
 Nil (default), which causes the default behaviour, :Always, which causes
 Self to be displayed in the Locals window for all functions, and any other
 non-nil value, which causes Self to be displayed in the locals window for
 all method functions.*")

;1;; Code by JPR.*
(DEFUN 4is-a-method* (FUNCTION)
  (AND (CONSP (FUNCTION-NAME function))
       (EQUAL :method (FIRST (FUNCTION-NAME function)))))

(DEFUN 4has-a-special-value* (symbol sg frame)
  (LET ((sp (sg-special-pdl sg)))
       (MULTIPLE-VALUE-BIND (start end)
	   (sg-frame-special-pdl-range sg frame)
	 (IGNORE end)
	 (IF (AND start end)
;	1 (if start*
;	1     (do ((i start (- i 2)))*
;		1 ((<= i 0)*
;		1  nil*
	     (DO ((i start (+ i 2)))
		 ((>= i end)
		  nil)
	       (IF (EQ symbol
		       (symbol-from-value-cell-location (AREF sp (1+ i))))
		   (MULTIPLE-VALUE-BIND (val error)
		       (CATCH-ERROR (AREF sp i) nil)
		     (IF error
			 (RETURN nil)
			 (RETURN (LIST symbol val))))
		   nil))
	     nil))))

(DEFUN 4specials-used-by-fef* (fef &optional (sg nil) (frame nil))
  (LET ((specials nil)
	(old-disassemble-pointer #'compiler:disassemble-pointer))
       (letf ((#'compiler:disassemble-pointer
	       #'(lambda (&rest args)
		   (LET ((result (APPLY old-disassemble-pointer args)))
		        (IF (AND result
				 (SYMBOLP result))
			    (PUSHNEW result specials)
			    nil)
			result))))
	     (DO ((i 0 (1+ i))
		  (pc (fef-initial-pc fef)
		      (+ pc (compiler:disassemble-instruction-length fef pc)))
		  (lim-pc (compiler:disassemble-lim-pc fef)))
		 ((>= pc lim-pc))
	       (LET ((*standard-output* 'si:null-stream))
		    (compiler:disassemble-instruction fef pc))))
       (REMOVE nil (MAPCAR #'(lambda (x)
			       (IF sg
				   (has-a-special-value x sg frame)
				   (IF (GET x 'SPECIAL) x nil)))
			     specials))))

(DEFVAR 4*show-referenced-specials-in-locals-window** t
"2When true specials that are read are shown in the debugger's locals window as
 well as those that are bound.*")

(DEFUN 4setup-locals-window* (window sg frame rest-arg-p)
  (LET* (LIST
         (rp (sg-regular-pdl sg))
         (FUNCTION (rp-function-word rp frame))
         (sp (sg-special-pdl sg))
         start end self-value 
	 ;1; Added by JPR.*
	 local-specials self-mapping-table-value)
    ;1; Print the locals if this is a fef*
    (IF (TYPEP function 'compiled-function)
        (DO ((n-locals (fef-number-of-locals function))
             (local-idx (sys:rp-local-offset sg rp frame))
             (i 0 (1+ i)))
;1;*	1   (J (+ FRAME (RP-LOCAL-BLOCK-ORIGIN RP FRAME)) (1+ J)))  ;; * old way to find locals **
            ((>= i n-locals))
          (COND ((NOT (AND rest-arg-p (ZEROP i)))     ;1; Don't show rest arg (local 0) twice*
                 (PUSH (LIST (local-name function i)  ;1; Local Name*
;1;*			1   (AREF RP J)*
                             (AREF rp (+ i local-idx))        ;1 Local Value*
                             i)                       ;1 Local Number*
                       list)))))
    ;1; Print the specials if any*
    (MULTIPLE-VALUE-SETQ (start end)
                         (sg-frame-special-pdl-range sg frame))
    (WHEN start
      (PUSH "" list)
      (PUSH "3Specials:*" list)
      (DO ((i start (+ i 2)))
          ((>= i end))
        (IF (EQ 'self (symbol-from-value-cell-location (AREF sp (1+ i))))
            (SETQ self-value (AREF sp i)))

	;1; This code by JPR.*
	(IF (EQ 'sys:self-mapping-table
		(symbol-from-value-cell-location (AREF sp (1+ i))))
            (SETQ self-mapping-table-value (AREF sp i)))
	(PUSH (symbol-from-value-cell-location (AREF sp (1+ i))) local-specials)

        (PUSH (LIST (symbol-from-value-cell-location (AREF sp (1+ i)))  ;1; Name*
                    (MULTIPLE-VALUE-BIND (val error)  ;1; Value*
                        (CATCH-ERROR (AREF sp i) nil)
                      (IF error "3unbound*" val)))
              list)))
    ;1; This code by JPR.*
    (LET ((specials (IF (AND *show-referenced-specials-in-locals-window*
			     (TYPEP function 'compiled-function))
			(REMOVE-IF
			  #'(lambda (x) (MEMBER (FIRST x) local-specials))
			  (specials-used-by-fef function sg frame))
			nil)))
      (IF (AND specials (NOT  start))
	     (PROGN (PUSH "" list) (PUSH "3Specials:*" list)))
	 (LOOP for (name value) in specials
	       do (PUSH (LIST name value) list)))
    ;1; This code by JPR.*
    (IF (AND *show-self-in-locals-window-anyway*
	     (NOT self-value)
	     (OR (EQUAL :always *show-self-in-locals-window-anyway*)
		 (is-a-method function)))
	(PROGN (IF (NOT start)
		   (PROGN (PUSH "" list)
			  (PUSH "3Specials:*" list)))
	       (PUSH (LIST 'self
			   (CATCH-ERROR
			     (SYMEVAL-IN-STACK-GROUP 'self sg frame) nil))
		     list)
	       (IF (NOT self-mapping-table-value)
		   (PUSH (LIST 'sys:self-mapping-table
			       (CATCH-ERROR
				 (SYMEVAL-IN-STACK-GROUP
				   'sys:self-mapping-table sg frame) nil))
			 list))))
    ;1; if SELF is mentioned in this frame, include its instance variables:*
    (IF (AND self-value
             (TYPEP self-value 'instance))
        (LET* ((self-flavor 
                 (si:instance-flavor self-value))
               (self-vars (si::flavor-all-instance-variables-slow self-flavor)))
          (PUSH "" list)
          (PUSH "3Non-special instance variables of SELF:*" list)
          (DO ((sv self-vars (CDR sv))
               (i 1 (1+ i)))
              ((NULL sv))
            (COND ((NOT (si::assq-careful (CAR sv) list))
                   (PUSH (LIST (CAR sv)
                               (MULTIPLE-VALUE-BIND (val error)       ;1Value*
                                   (CATCH-ERROR (%instance-ref self-value i) nil)
                                 (IF error "3unbound*" val)))
                         list))))))
    (SEND window :setup (LIST 'print-arg-or-local '(local "3Local*") (NREVERSE list)))))

;1-------------------------------------------------------------------------------*
;1;; Special searching...*
;1 TAC 08-08-89 - bug in here somewhere that blows the machine away if you do *
;1                the searching for specials bound-by or bound-in frame.*

(DEFUN 4specials-bound-by-frame* (sg frame)
  (LET ((result nil))
       (MULTIPLE-VALUE-BIND (start end) (sg-frame-special-pdl-range sg frame)
	 (IF start
	     (DO ((i start (+ i 2))) ((>= i end))
	       (PUSH (symbol-from-value-cell-location
		       (AREF (sg-special-pdl sg) (1+ i)))
		     result))
	     nil))
      result))

(DEFUN 4special-bound-in-frame* (symbol sg frame)
  (LET ((syms (specials-bound-by-frame sg frame)))
    (MEMBER symbol syms :test
	    #'(lambda (a b)
		(SEARCH (SYMBOL-NAME a) (SYMBOL-NAME b)
			:test #'STRING-EQUAL)))))

(DEFUN 4special-used-in-frame* (symbol sg frame)
  (LET ((syms (specials-used-by-fef
		(rp-function-word (sg-regular-pdl sg) frame) sg frame)))
       (MEMBER symbol syms :test
	 #'(lambda (a b)
	     (SEARCH (SYMBOL-NAME a) (SYMBOL-NAME (ucl::first-if-list b))
		     :test #'STRING-EQUAL)))))

(DEFUN 4get-something-and-search-for-it* (sg from-frame)
  (LET ((thing (window-read-thing-dont-eval
		 "3Type or mouse on a special to search for: *")))
       (LET ((frame (DO ((frame from-frame (sg-next-frame sg frame)))
			((NULL frame) nil)
		      (IF (IF (EQUAL 2 *numeric-arg*)
			      (special-used-in-frame  thing sg frame)
			      (special-bound-in-frame thing sg frame))
			  (RETURN frame)
			  nil))))
	    frame)))

(DEFUN 4search-for-special* (sg frame)
   (SEND *window-debugger* :set-who-line-doc-string-overide
	 "3Select a special to search for.*")
   (UNWIND-PROTECT (get-something-and-search-for-it sg frame)
      (SEND *window-debugger* :set-who-line-doc-string-overide nil)
      (SEND *window-debugger* :handle-prompt)))

(DEFCOMMAND 4comw-search-cmd* (*numeric-arg*)
            '(:description  
              "3Search stack for a frame whose function's name contains a specified string.  
With numeric arg, search stack for frame that binds [arg = 2 -> uses] a special.*"  
              :names "3Search*"
	      :arguments (ucl:numeric-argument)
              :keys (#\c-s))
            (UNWIND-PROTECT (comw-search *error-sg* *error-object*)
                            (SEND *window-debugger* :handle-prompt)))

(DEFUN 4comw-search* (sg ignore)
  (IF (AND *numeric-arg* (PLUSP *numeric-arg*))
      (LET ((frame (get-something-and-search-for-it sg *current-frame*)))
	(COND ((NULL frame)
	       (FORMAT t "3Search failed.~%*"))
	      (t
	       (SETQ *current-frame* frame)
;	1       (SETF ucl:top-level-self*
;		1     (SYMEVAL-IN-STACK-GROUP*
;		1       'self ucl:*stack-group* *current-frame*))*
;1 TAC 09-04-89*
	       (SETF ucl::top-level-self		
		     (SYMEVAL-IN-STACK-GROUP
		       'self *error-sg* *current-frame*))
	       (SEND *window-debugger* :setup-frame sg *current-frame*))))
	(LET (key frame)
	  (FORMAT t "3String to search for (end with RETURN):~%*")
	  (SETQ key (READ-LINE))
	  (SETQ frame 
		(DO ((frame *current-frame* (sg-next-frame sg frame))
		     (rp (sg-regular-pdl sg))
		     (name))
		    ((NULL frame) nil)
		  (SETQ name (FUNCTION-NAME (rp-function-word rp frame)))
		  (SETQ name (COND ((STRINGP name) name)
				   ((SYMBOLP name) (STRING name))
				   (t (FORMAT nil "3~S*" name))))
		  (AND (SEARCH key name :test #'STRING-EQUAL) (RETURN frame))))
	  (COND ((NULL frame)
		 (FORMAT t "3Search failed.~%*"))
		(t
		 (SETQ *current-frame* frame)
;		1 (SETF ucl:top-level-self*
;		1       (SYMEVAL-IN-STACK-GROUP*
;			1 'self ucl:*stack-group* *current-frame*))*
;1 TAC 09-04-89*
		 (SETF ucl::top-level-self
		       (SYMEVAL-IN-STACK-GROUP
			 'self *error-sg* *current-frame*))
		 (SEND *window-debugger* :setup-frame sg *current-frame*))))))

;1^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*

;1 tac 08-08-89 - bug in here somewhere that blows the machine away if you do *
;1                the searching for specials bound-by or bound-in frame.*

(DEFUN 4com-search* (sg error-object &optional numeric-arg flag)
  "2Searches down the stack for a frame whose function name contains a specified string.  With numeric arg, 
search stack for frame that binds [arg = 2 -> uses] a special.*"
  (DECLARE (SPECIAL *current-frame*)
	   (IGNORE error-object))
  (IF numeric-arg
      (LET ((frame (get-something-and-search-for-it sg *current-frame*)))
	(COND ((NULL frame)
	       (FORMAT t "3Search failed.~%*"))
	      (t
	       (SETQ *current-frame* frame)
	       (IF flag
		   (show-all sg)
		   (show-function-and-args sg)))))
      (PROGN
	(FORMAT t "3~%String to search for (end with RETURN):~%*")
	(LET* ((key (READ-LINE))
	       ;1; Look for frame whose function name contains KEY.*
	       ;1; If found print function and its args.*
	       (frame (DO ((frame *current-frame* (sg-next-frame sg frame))
			   (rp (sg-regular-pdl sg))
			   (name))
			  ((NULL frame) nil)
			(SETQ name (FUNCTION-NAME (rp-function-word rp frame)))
			(SETQ name (COND ((STRINGP name) name)
					 ((SYMBOLP name) (STRING name))
					 (t (FORMAT nil "3~S*" name))))
			(IF (SEARCH key (THE string name) :test #'CHAR-EQUAL) 
			    (RETURN frame)))))
	  (COND ((NULL frame)
		 (FORMAT t "3Search failed.~%*"))
		(t
		 (SETQ *current-frame* frame)
		 (IF flag
		     (show-all sg)
		     (show-function-and-args sg))))))))

;1-------------------------------------------------------------------------------

*(install-window-debugger-commands)